package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait BudgetStatus {
  def unwrap: software.amazon.awssdk.services.deadline.model.BudgetStatus
}
object BudgetStatus {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.BudgetStatus
  ): zio.aws.deadline.model.BudgetStatus = value match {
    case software.amazon.awssdk.services.deadline.model.BudgetStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.BudgetStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.deadline.model.BudgetStatus.INACTIVE =>
      val r = INACTIVE
      r
  }
  case object unknownToSdkVersion extends zio.aws.deadline.model.BudgetStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.BudgetStatus =
      software.amazon.awssdk.services.deadline.model.BudgetStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.deadline.model.BudgetStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.BudgetStatus =
      software.amazon.awssdk.services.deadline.model.BudgetStatus.ACTIVE
  }
  case object INACTIVE extends zio.aws.deadline.model.BudgetStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.BudgetStatus =
      software.amazon.awssdk.services.deadline.model.BudgetStatus.INACTIVE
  }
}
