package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait ComparisonOperator {
  def unwrap: software.amazon.awssdk.services.deadline.model.ComparisonOperator
}
object ComparisonOperator {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.ComparisonOperator
  ): zio.aws.deadline.model.ComparisonOperator = value match {
    case software.amazon.awssdk.services.deadline.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.ComparisonOperator.EQUAL =>
      val r = EQUAL
      r
    case software.amazon.awssdk.services.deadline.model.ComparisonOperator.NOT_EQUAL =>
      val r = NOT_EQUAL
      r
    case software.amazon.awssdk.services.deadline.model.ComparisonOperator.GREATER_THAN_EQUAL_TO =>
      val r = GREATER_THAN_EQUAL_TO
      r
    case software.amazon.awssdk.services.deadline.model.ComparisonOperator.GREATER_THAN =>
      val r = GREATER_THAN
      r
    case software.amazon.awssdk.services.deadline.model.ComparisonOperator.LESS_THAN_EQUAL_TO =>
      val r = LESS_THAN_EQUAL_TO
      r
    case software.amazon.awssdk.services.deadline.model.ComparisonOperator.LESS_THAN =>
      val r = LESS_THAN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.ComparisonOperator =
      software.amazon.awssdk.services.deadline.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object EQUAL extends zio.aws.deadline.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.ComparisonOperator =
      software.amazon.awssdk.services.deadline.model.ComparisonOperator.EQUAL
  }
  case object NOT_EQUAL extends zio.aws.deadline.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.ComparisonOperator =
      software.amazon.awssdk.services.deadline.model.ComparisonOperator.NOT_EQUAL
  }
  case object GREATER_THAN_EQUAL_TO
      extends zio.aws.deadline.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.ComparisonOperator =
      software.amazon.awssdk.services.deadline.model.ComparisonOperator.GREATER_THAN_EQUAL_TO
  }
  case object GREATER_THAN extends zio.aws.deadline.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.ComparisonOperator =
      software.amazon.awssdk.services.deadline.model.ComparisonOperator.GREATER_THAN
  }
  case object LESS_THAN_EQUAL_TO
      extends zio.aws.deadline.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.ComparisonOperator =
      software.amazon.awssdk.services.deadline.model.ComparisonOperator.LESS_THAN_EQUAL_TO
  }
  case object LESS_THAN extends zio.aws.deadline.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.ComparisonOperator =
      software.amazon.awssdk.services.deadline.model.ComparisonOperator.LESS_THAN
  }
}
