package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait CompletedStatus {
  def unwrap: software.amazon.awssdk.services.deadline.model.CompletedStatus
}
object CompletedStatus {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.CompletedStatus
  ): zio.aws.deadline.model.CompletedStatus = value match {
    case software.amazon.awssdk.services.deadline.model.CompletedStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.CompletedStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.deadline.model.CompletedStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.deadline.model.CompletedStatus.INTERRUPTED =>
      val r = INTERRUPTED
      r
    case software.amazon.awssdk.services.deadline.model.CompletedStatus.CANCELED =>
      val r = CANCELED
      r
    case software.amazon.awssdk.services.deadline.model.CompletedStatus.NEVER_ATTEMPTED =>
      val r = NEVER_ATTEMPTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.CompletedStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.CompletedStatus =
      software.amazon.awssdk.services.deadline.model.CompletedStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCEEDED extends zio.aws.deadline.model.CompletedStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.CompletedStatus =
      software.amazon.awssdk.services.deadline.model.CompletedStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.deadline.model.CompletedStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.CompletedStatus =
      software.amazon.awssdk.services.deadline.model.CompletedStatus.FAILED
  }
  case object INTERRUPTED extends zio.aws.deadline.model.CompletedStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.CompletedStatus =
      software.amazon.awssdk.services.deadline.model.CompletedStatus.INTERRUPTED
  }
  case object CANCELED extends zio.aws.deadline.model.CompletedStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.CompletedStatus =
      software.amazon.awssdk.services.deadline.model.CompletedStatus.CANCELED
  }
  case object NEVER_ATTEMPTED extends zio.aws.deadline.model.CompletedStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.CompletedStatus =
      software.amazon.awssdk.services.deadline.model.CompletedStatus.NEVER_ATTEMPTED
  }
}
