package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ConsumedUsages(approximateDollarUsage: Float) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ConsumedUsages = {
    import ConsumedUsages.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ConsumedUsages
      .builder()
      .approximateDollarUsage(approximateDollarUsage: java.lang.Float)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ConsumedUsages.ReadOnly =
    zio.aws.deadline.model.ConsumedUsages.wrap(buildAwsValue())
}
object ConsumedUsages {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ConsumedUsages
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ConsumedUsages =
      zio.aws.deadline.model.ConsumedUsages(approximateDollarUsage)
    def approximateDollarUsage: Float
    def getApproximateDollarUsage: ZIO[Any, Nothing, Float] =
      ZIO.succeed(approximateDollarUsage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ConsumedUsages
  ) extends zio.aws.deadline.model.ConsumedUsages.ReadOnly {
    override val approximateDollarUsage: Float =
      impl.approximateDollarUsage(): Float
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ConsumedUsages
  ): zio.aws.deadline.model.ConsumedUsages.ReadOnly = new Wrapper(impl)
}
