package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{QueueId, JobId, FarmId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CopyJobTemplateRequest(
    farmId: FarmId,
    jobId: JobId,
    queueId: QueueId,
    targetS3Location: zio.aws.deadline.model.S3Location
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CopyJobTemplateRequest = {
    import CopyJobTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CopyJobTemplateRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .targetS3Location(targetS3Location.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.CopyJobTemplateRequest.ReadOnly =
    zio.aws.deadline.model.CopyJobTemplateRequest.wrap(buildAwsValue())
}
object CopyJobTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CopyJobTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CopyJobTemplateRequest =
      zio.aws.deadline.model.CopyJobTemplateRequest(
        farmId,
        jobId,
        queueId,
        targetS3Location.asEditable
      )
    def farmId: FarmId
    def jobId: JobId
    def queueId: QueueId
    def targetS3Location: zio.aws.deadline.model.S3Location.ReadOnly
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getTargetS3Location
        : ZIO[Any, Nothing, zio.aws.deadline.model.S3Location.ReadOnly] =
      ZIO.succeed(targetS3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CopyJobTemplateRequest
  ) extends zio.aws.deadline.model.CopyJobTemplateRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val targetS3Location: zio.aws.deadline.model.S3Location.ReadOnly =
      zio.aws.deadline.model.S3Location.wrap(impl.targetS3Location())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CopyJobTemplateRequest
  ): zio.aws.deadline.model.CopyJobTemplateRequest.ReadOnly = new Wrapper(impl)
}
