package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CopyJobTemplateResponse(
    templateType: zio.aws.deadline.model.JobTemplateType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CopyJobTemplateResponse = {
    import CopyJobTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CopyJobTemplateResponse
      .builder()
      .templateType(templateType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.CopyJobTemplateResponse.ReadOnly =
    zio.aws.deadline.model.CopyJobTemplateResponse.wrap(buildAwsValue())
}
object CopyJobTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CopyJobTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CopyJobTemplateResponse =
      zio.aws.deadline.model.CopyJobTemplateResponse(templateType)
    def templateType: zio.aws.deadline.model.JobTemplateType
    def getTemplateType
        : ZIO[Any, Nothing, zio.aws.deadline.model.JobTemplateType] =
      ZIO.succeed(templateType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CopyJobTemplateResponse
  ) extends zio.aws.deadline.model.CopyJobTemplateResponse.ReadOnly {
    override val templateType: zio.aws.deadline.model.JobTemplateType =
      zio.aws.deadline.model.JobTemplateType.wrap(impl.templateType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CopyJobTemplateResponse
  ): zio.aws.deadline.model.CopyJobTemplateResponse.ReadOnly = new Wrapper(impl)
}
