package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait CpuArchitectureType {
  def unwrap: software.amazon.awssdk.services.deadline.model.CpuArchitectureType
}
object CpuArchitectureType {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.CpuArchitectureType
  ): zio.aws.deadline.model.CpuArchitectureType = value match {
    case software.amazon.awssdk.services.deadline.model.CpuArchitectureType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.CpuArchitectureType.X86_64 =>
      val r = x86_64
      r
    case software.amazon.awssdk.services.deadline.model.CpuArchitectureType.ARM64 =>
      val r = arm64
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.CpuArchitectureType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.CpuArchitectureType =
      software.amazon.awssdk.services.deadline.model.CpuArchitectureType.UNKNOWN_TO_SDK_VERSION
  }
  case object x86_64 extends zio.aws.deadline.model.CpuArchitectureType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.CpuArchitectureType =
      software.amazon.awssdk.services.deadline.model.CpuArchitectureType.X86_64
  }
  case object arm64 extends zio.aws.deadline.model.CpuArchitectureType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.CpuArchitectureType =
      software.amazon.awssdk.services.deadline.model.CpuArchitectureType.ARM64
  }
}
