package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  FarmId,
  Description,
  ClientToken,
  ConsumedUsageLimit,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateBudgetRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    farmId: FarmId,
    usageTrackingResource: zio.aws.deadline.model.UsageTrackingResource,
    displayName: ResourceName,
    description: Optional[Description] = Optional.Absent,
    approximateDollarLimit: ConsumedUsageLimit,
    actions: Iterable[zio.aws.deadline.model.BudgetActionToAdd],
    schedule: zio.aws.deadline.model.BudgetSchedule
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CreateBudgetRequest = {
    import CreateBudgetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CreateBudgetRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .usageTrackingResource(usageTrackingResource.buildAwsValue())
      .displayName(ResourceName.unwrap(displayName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .approximateDollarLimit(
        ConsumedUsageLimit.unwrap(approximateDollarLimit): java.lang.Float
      )
      .actions(actions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .schedule(schedule.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.CreateBudgetRequest.ReadOnly =
    zio.aws.deadline.model.CreateBudgetRequest.wrap(buildAwsValue())
}
object CreateBudgetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CreateBudgetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CreateBudgetRequest =
      zio.aws.deadline.model.CreateBudgetRequest(
        clientToken.map(value => value),
        farmId,
        usageTrackingResource.asEditable,
        displayName,
        description.map(value => value),
        approximateDollarLimit,
        actions.map { item =>
          item.asEditable
        },
        schedule.asEditable
      )
    def clientToken: Optional[ClientToken]
    def farmId: FarmId
    def usageTrackingResource
        : zio.aws.deadline.model.UsageTrackingResource.ReadOnly
    def displayName: ResourceName
    def description: Optional[Description]
    def approximateDollarLimit: ConsumedUsageLimit
    def actions: List[zio.aws.deadline.model.BudgetActionToAdd.ReadOnly]
    def schedule: zio.aws.deadline.model.BudgetSchedule.ReadOnly
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getUsageTrackingResource: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.UsageTrackingResource.ReadOnly
    ] = ZIO.succeed(usageTrackingResource)
    def getDisplayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(displayName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getApproximateDollarLimit: ZIO[Any, Nothing, ConsumedUsageLimit] =
      ZIO.succeed(approximateDollarLimit)
    def getActions: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.BudgetActionToAdd.ReadOnly
    ]] = ZIO.succeed(actions)
    def getSchedule
        : ZIO[Any, Nothing, zio.aws.deadline.model.BudgetSchedule.ReadOnly] =
      ZIO.succeed(schedule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CreateBudgetRequest
  ) extends zio.aws.deadline.model.CreateBudgetRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.deadline.model.primitives.ClientToken(value))
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val usageTrackingResource
        : zio.aws.deadline.model.UsageTrackingResource.ReadOnly =
      zio.aws.deadline.model.UsageTrackingResource
        .wrap(impl.usageTrackingResource())
    override val displayName: ResourceName =
      zio.aws.deadline.model.primitives.ResourceName(impl.displayName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.deadline.model.primitives.Description(value))
    override val approximateDollarLimit: ConsumedUsageLimit =
      zio.aws.deadline.model.primitives
        .ConsumedUsageLimit(impl.approximateDollarLimit())
    override val actions
        : List[zio.aws.deadline.model.BudgetActionToAdd.ReadOnly] = impl
      .actions()
      .asScala
      .map { item =>
        zio.aws.deadline.model.BudgetActionToAdd.wrap(item)
      }
      .toList
    override val schedule: zio.aws.deadline.model.BudgetSchedule.ReadOnly =
      zio.aws.deadline.model.BudgetSchedule.wrap(impl.schedule())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CreateBudgetRequest
  ): zio.aws.deadline.model.CreateBudgetRequest.ReadOnly = new Wrapper(impl)
}
