package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.BudgetId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateBudgetResponse(budgetId: BudgetId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CreateBudgetResponse = {
    import CreateBudgetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CreateBudgetResponse
      .builder()
      .budgetId(BudgetId.unwrap(budgetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.CreateBudgetResponse.ReadOnly =
    zio.aws.deadline.model.CreateBudgetResponse.wrap(buildAwsValue())
}
object CreateBudgetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CreateBudgetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CreateBudgetResponse =
      zio.aws.deadline.model.CreateBudgetResponse(budgetId)
    def budgetId: BudgetId
    def getBudgetId: ZIO[Any, Nothing, BudgetId] = ZIO.succeed(budgetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CreateBudgetResponse
  ) extends zio.aws.deadline.model.CreateBudgetResponse.ReadOnly {
    override val budgetId: BudgetId =
      zio.aws.deadline.model.primitives.BudgetId(impl.budgetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CreateBudgetResponse
  ): zio.aws.deadline.model.CreateBudgetResponse.ReadOnly = new Wrapper(impl)
}
