package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  KmsKeyArn,
  Description,
  ResourceName,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFarmRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    displayName: ResourceName,
    description: Optional[Description] = Optional.Absent,
    kmsKeyArn: Optional[KmsKeyArn] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CreateFarmRequest = {
    import CreateFarmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CreateFarmRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .displayName(ResourceName.unwrap(displayName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        kmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.CreateFarmRequest.ReadOnly =
    zio.aws.deadline.model.CreateFarmRequest.wrap(buildAwsValue())
}
object CreateFarmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CreateFarmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CreateFarmRequest =
      zio.aws.deadline.model.CreateFarmRequest(
        clientToken.map(value => value),
        displayName,
        description.map(value => value),
        kmsKeyArn.map(value => value),
        tags.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def displayName: ResourceName
    def description: Optional[Description]
    def kmsKeyArn: Optional[KmsKeyArn]
    def tags: Optional[Map[String, String]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDisplayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(displayName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CreateFarmRequest
  ) extends zio.aws.deadline.model.CreateFarmRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.deadline.model.primitives.ClientToken(value))
    override val displayName: ResourceName =
      zio.aws.deadline.model.primitives.ResourceName(impl.displayName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.deadline.model.primitives.Description(value))
    override val kmsKeyArn: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.deadline.model.primitives.KmsKeyArn(value))
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CreateFarmRequest
  ): zio.aws.deadline.model.CreateFarmRequest.ReadOnly = new Wrapper(impl)
}
