package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.FarmId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateFarmResponse(farmId: FarmId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CreateFarmResponse = {
    import CreateFarmResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CreateFarmResponse
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.CreateFarmResponse.ReadOnly =
    zio.aws.deadline.model.CreateFarmResponse.wrap(buildAwsValue())
}
object CreateFarmResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CreateFarmResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CreateFarmResponse =
      zio.aws.deadline.model.CreateFarmResponse(farmId)
    def farmId: FarmId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CreateFarmResponse
  ) extends zio.aws.deadline.model.CreateFarmResponse.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CreateFarmResponse
  ): zio.aws.deadline.model.CreateFarmResponse.ReadOnly = new Wrapper(impl)
}
