package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  IamRoleArn,
  FarmId,
  Description,
  ClientToken,
  MinZeroMaxInteger,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class CreateFleetRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    farmId: FarmId,
    displayName: ResourceName,
    description: Optional[Description] = Optional.Absent,
    roleArn: IamRoleArn,
    minWorkerCount: Optional[MinZeroMaxInteger] = Optional.Absent,
    maxWorkerCount: MinZeroMaxInteger,
    configuration: zio.aws.deadline.model.FleetConfiguration,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CreateFleetRequest = {
    import CreateFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CreateFleetRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .displayName(ResourceName.unwrap(displayName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .roleArn(IamRoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        minWorkerCount.map(value => MinZeroMaxInteger.unwrap(value): Integer)
      )(_.minWorkerCount)
      .maxWorkerCount(MinZeroMaxInteger.unwrap(maxWorkerCount): Integer)
      .configuration(configuration.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.CreateFleetRequest.ReadOnly =
    zio.aws.deadline.model.CreateFleetRequest.wrap(buildAwsValue())
}
object CreateFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CreateFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CreateFleetRequest =
      zio.aws.deadline.model.CreateFleetRequest(
        clientToken.map(value => value),
        farmId,
        displayName,
        description.map(value => value),
        roleArn,
        minWorkerCount.map(value => value),
        maxWorkerCount,
        configuration.asEditable,
        tags.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def farmId: FarmId
    def displayName: ResourceName
    def description: Optional[Description]
    def roleArn: IamRoleArn
    def minWorkerCount: Optional[MinZeroMaxInteger]
    def maxWorkerCount: MinZeroMaxInteger
    def configuration: zio.aws.deadline.model.FleetConfiguration.ReadOnly
    def tags: Optional[Map[String, String]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getDisplayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(displayName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, Nothing, IamRoleArn] = ZIO.succeed(roleArn)
    def getMinWorkerCount: ZIO[Any, AwsError, MinZeroMaxInteger] =
      AwsError.unwrapOptionField("minWorkerCount", minWorkerCount)
    def getMaxWorkerCount: ZIO[Any, Nothing, MinZeroMaxInteger] =
      ZIO.succeed(maxWorkerCount)
    def getConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.FleetConfiguration.ReadOnly
    ] = ZIO.succeed(configuration)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CreateFleetRequest
  ) extends zio.aws.deadline.model.CreateFleetRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.deadline.model.primitives.ClientToken(value))
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val displayName: ResourceName =
      zio.aws.deadline.model.primitives.ResourceName(impl.displayName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.deadline.model.primitives.Description(value))
    override val roleArn: IamRoleArn =
      zio.aws.deadline.model.primitives.IamRoleArn(impl.roleArn())
    override val minWorkerCount: Optional[MinZeroMaxInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minWorkerCount())
        .map(value =>
          zio.aws.deadline.model.primitives.MinZeroMaxInteger(value)
        )
    override val maxWorkerCount: MinZeroMaxInteger =
      zio.aws.deadline.model.primitives.MinZeroMaxInteger(impl.maxWorkerCount())
    override val configuration
        : zio.aws.deadline.model.FleetConfiguration.ReadOnly =
      zio.aws.deadline.model.FleetConfiguration.wrap(impl.configuration())
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CreateFleetRequest
  ): zio.aws.deadline.model.CreateFleetRequest.ReadOnly = new Wrapper(impl)
}
