package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.FleetId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateFleetResponse(fleetId: FleetId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CreateFleetResponse = {
    import CreateFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CreateFleetResponse
      .builder()
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.CreateFleetResponse.ReadOnly =
    zio.aws.deadline.model.CreateFleetResponse.wrap(buildAwsValue())
}
object CreateFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CreateFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CreateFleetResponse =
      zio.aws.deadline.model.CreateFleetResponse(fleetId)
    def fleetId: FleetId
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CreateFleetResponse
  ) extends zio.aws.deadline.model.CreateFleetResponse.ReadOnly {
    override val fleetId: FleetId =
      zio.aws.deadline.model.primitives.FleetId(impl.fleetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CreateFleetResponse
  ): zio.aws.deadline.model.CreateFleetResponse.ReadOnly = new Wrapper(impl)
}
