package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  JobTemplate,
  QueueId,
  MaxFailedTasksCount,
  FarmId,
  JobPriority,
  MaxRetriesPerTask,
  StorageProfileId,
  JobId,
  ClientToken
}
import scala.jdk.CollectionConverters._
final case class CreateJobRequest(
    farmId: FarmId,
    queueId: QueueId,
    clientToken: Optional[ClientToken] = Optional.Absent,
    template: Optional[JobTemplate] = Optional.Absent,
    templateType: Optional[zio.aws.deadline.model.JobTemplateType] =
      Optional.Absent,
    priority: JobPriority,
    parameters: Optional[Map[String, zio.aws.deadline.model.JobParameter]] =
      Optional.Absent,
    attachments: Optional[zio.aws.deadline.model.Attachments] = Optional.Absent,
    storageProfileId: Optional[StorageProfileId] = Optional.Absent,
    targetTaskRunStatus: Optional[
      zio.aws.deadline.model.CreateJobTargetTaskRunStatus
    ] = Optional.Absent,
    maxFailedTasksCount: Optional[MaxFailedTasksCount] = Optional.Absent,
    maxRetriesPerTask: Optional[MaxRetriesPerTask] = Optional.Absent,
    sourceJobId: Optional[JobId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CreateJobRequest = {
    import CreateJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CreateJobRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        template.map(value => JobTemplate.unwrap(value): java.lang.String)
      )(_.template)
      .optionallyWith(templateType.map(value => value.unwrap))(_.templateType)
      .priority(JobPriority.unwrap(priority): Integer)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(attachments.map(value => value.buildAwsValue()))(
        _.attachments
      )
      .optionallyWith(
        storageProfileId.map(value =>
          StorageProfileId.unwrap(value): java.lang.String
        )
      )(_.storageProfileId)
      .optionallyWith(targetTaskRunStatus.map(value => value.unwrap))(
        _.targetTaskRunStatus
      )
      .optionallyWith(
        maxFailedTasksCount.map(value =>
          MaxFailedTasksCount.unwrap(value): Integer
        )
      )(_.maxFailedTasksCount)
      .optionallyWith(
        maxRetriesPerTask.map(value => MaxRetriesPerTask.unwrap(value): Integer)
      )(_.maxRetriesPerTask)
      .optionallyWith(
        sourceJobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.sourceJobId)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.CreateJobRequest.ReadOnly =
    zio.aws.deadline.model.CreateJobRequest.wrap(buildAwsValue())
}
object CreateJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CreateJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CreateJobRequest =
      zio.aws.deadline.model.CreateJobRequest(
        farmId,
        queueId,
        clientToken.map(value => value),
        template.map(value => value),
        templateType.map(value => value),
        priority,
        parameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        attachments.map(value => value.asEditable),
        storageProfileId.map(value => value),
        targetTaskRunStatus.map(value => value),
        maxFailedTasksCount.map(value => value),
        maxRetriesPerTask.map(value => value),
        sourceJobId.map(value => value)
      )
    def farmId: FarmId
    def queueId: QueueId
    def clientToken: Optional[ClientToken]
    def template: Optional[JobTemplate]
    def templateType: Optional[zio.aws.deadline.model.JobTemplateType]
    def priority: JobPriority
    def parameters
        : Optional[Map[String, zio.aws.deadline.model.JobParameter.ReadOnly]]
    def attachments: Optional[zio.aws.deadline.model.Attachments.ReadOnly]
    def storageProfileId: Optional[StorageProfileId]
    def targetTaskRunStatus
        : Optional[zio.aws.deadline.model.CreateJobTargetTaskRunStatus]
    def maxFailedTasksCount: Optional[MaxFailedTasksCount]
    def maxRetriesPerTask: Optional[MaxRetriesPerTask]
    def sourceJobId: Optional[JobId]
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTemplate: ZIO[Any, AwsError, JobTemplate] =
      AwsError.unwrapOptionField("template", template)
    def getTemplateType
        : ZIO[Any, AwsError, zio.aws.deadline.model.JobTemplateType] =
      AwsError.unwrapOptionField("templateType", templateType)
    def getPriority: ZIO[Any, Nothing, JobPriority] = ZIO.succeed(priority)
    def getParameters: ZIO[Any, AwsError, Map[
      String,
      zio.aws.deadline.model.JobParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getAttachments
        : ZIO[Any, AwsError, zio.aws.deadline.model.Attachments.ReadOnly] =
      AwsError.unwrapOptionField("attachments", attachments)
    def getStorageProfileId: ZIO[Any, AwsError, StorageProfileId] =
      AwsError.unwrapOptionField("storageProfileId", storageProfileId)
    def getTargetTaskRunStatus: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.CreateJobTargetTaskRunStatus
    ] = AwsError.unwrapOptionField("targetTaskRunStatus", targetTaskRunStatus)
    def getMaxFailedTasksCount: ZIO[Any, AwsError, MaxFailedTasksCount] =
      AwsError.unwrapOptionField("maxFailedTasksCount", maxFailedTasksCount)
    def getMaxRetriesPerTask: ZIO[Any, AwsError, MaxRetriesPerTask] =
      AwsError.unwrapOptionField("maxRetriesPerTask", maxRetriesPerTask)
    def getSourceJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("sourceJobId", sourceJobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CreateJobRequest
  ) extends zio.aws.deadline.model.CreateJobRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.deadline.model.primitives.ClientToken(value))
    override val template: Optional[JobTemplate] = zio.aws.core.internal
      .optionalFromNullable(impl.template())
      .map(value => zio.aws.deadline.model.primitives.JobTemplate(value))
    override val templateType
        : Optional[zio.aws.deadline.model.JobTemplateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateType())
        .map(value => zio.aws.deadline.model.JobTemplateType.wrap(value))
    override val priority: JobPriority =
      zio.aws.deadline.model.primitives.JobPriority(impl.priority())
    override val parameters
        : Optional[Map[String, zio.aws.deadline.model.JobParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> zio.aws.deadline.model.JobParameter.wrap(value)
            })
            .toMap
        )
    override val attachments
        : Optional[zio.aws.deadline.model.Attachments.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachments())
        .map(value => zio.aws.deadline.model.Attachments.wrap(value))
    override val storageProfileId: Optional[StorageProfileId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageProfileId())
        .map(value => zio.aws.deadline.model.primitives.StorageProfileId(value))
    override val targetTaskRunStatus
        : Optional[zio.aws.deadline.model.CreateJobTargetTaskRunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetTaskRunStatus())
        .map(value =>
          zio.aws.deadline.model.CreateJobTargetTaskRunStatus.wrap(value)
        )
    override val maxFailedTasksCount: Optional[MaxFailedTasksCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxFailedTasksCount())
        .map(value =>
          zio.aws.deadline.model.primitives.MaxFailedTasksCount(value)
        )
    override val maxRetriesPerTask: Optional[MaxRetriesPerTask] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxRetriesPerTask())
        .map(value =>
          zio.aws.deadline.model.primitives.MaxRetriesPerTask(value)
        )
    override val sourceJobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceJobId())
      .map(value => zio.aws.deadline.model.primitives.JobId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CreateJobRequest
  ): zio.aws.deadline.model.CreateJobRequest.ReadOnly = new Wrapper(impl)
}
