package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateJobResponse(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CreateJobResponse = {
    import CreateJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CreateJobResponse
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.CreateJobResponse.ReadOnly =
    zio.aws.deadline.model.CreateJobResponse.wrap(buildAwsValue())
}
object CreateJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CreateJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CreateJobResponse =
      zio.aws.deadline.model.CreateJobResponse(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CreateJobResponse
  ) extends zio.aws.deadline.model.CreateJobResponse.ReadOnly {
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CreateJobResponse
  ): zio.aws.deadline.model.CreateJobResponse.ReadOnly = new Wrapper(impl)
}
