package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  SecurityGroupId,
  SubnetId,
  VpcId,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLicenseEndpointRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    vpcId: VpcId,
    subnetIds: Iterable[SubnetId],
    securityGroupIds: Iterable[SecurityGroupId],
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CreateLicenseEndpointRequest = {
    import CreateLicenseEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CreateLicenseEndpointRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .securityGroupIds(securityGroupIds.map { item =>
        SecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.CreateLicenseEndpointRequest.ReadOnly =
    zio.aws.deadline.model.CreateLicenseEndpointRequest.wrap(buildAwsValue())
}
object CreateLicenseEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CreateLicenseEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CreateLicenseEndpointRequest =
      zio.aws.deadline.model.CreateLicenseEndpointRequest(
        clientToken.map(value => value),
        vpcId,
        subnetIds,
        securityGroupIds,
        tags.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def vpcId: VpcId
    def subnetIds: List[SubnetId]
    def securityGroupIds: List[SecurityGroupId]
    def tags: Optional[Map[String, String]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
    def getSecurityGroupIds: ZIO[Any, Nothing, List[SecurityGroupId]] =
      ZIO.succeed(securityGroupIds)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CreateLicenseEndpointRequest
  ) extends zio.aws.deadline.model.CreateLicenseEndpointRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.deadline.model.primitives.ClientToken(value))
    override val vpcId: VpcId =
      zio.aws.deadline.model.primitives.VpcId(impl.vpcId())
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.deadline.model.primitives.SubnetId(item)
      }
      .toList
    override val securityGroupIds: List[SecurityGroupId] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.deadline.model.primitives.SecurityGroupId(item)
      }
      .toList
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CreateLicenseEndpointRequest
  ): zio.aws.deadline.model.CreateLicenseEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
