package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.LicenseEndpointId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateLicenseEndpointResponse(
    licenseEndpointId: LicenseEndpointId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CreateLicenseEndpointResponse = {
    import CreateLicenseEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CreateLicenseEndpointResponse
      .builder()
      .licenseEndpointId(
        LicenseEndpointId.unwrap(licenseEndpointId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.CreateLicenseEndpointResponse.ReadOnly =
    zio.aws.deadline.model.CreateLicenseEndpointResponse.wrap(buildAwsValue())
}
object CreateLicenseEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CreateLicenseEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CreateLicenseEndpointResponse =
      zio.aws.deadline.model.CreateLicenseEndpointResponse(licenseEndpointId)
    def licenseEndpointId: LicenseEndpointId
    def getLicenseEndpointId: ZIO[Any, Nothing, LicenseEndpointId] =
      ZIO.succeed(licenseEndpointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CreateLicenseEndpointResponse
  ) extends zio.aws.deadline.model.CreateLicenseEndpointResponse.ReadOnly {
    override val licenseEndpointId: LicenseEndpointId =
      zio.aws.deadline.model.primitives
        .LicenseEndpointId(impl.licenseEndpointId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CreateLicenseEndpointResponse
  ): zio.aws.deadline.model.CreateLicenseEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
