package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  IamRoleArn,
  Subdomain,
  ClientToken,
  IdentityCenterInstanceArn,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateMonitorRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    displayName: ResourceName,
    identityCenterInstanceArn: IdentityCenterInstanceArn,
    subdomain: Subdomain,
    roleArn: IamRoleArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CreateMonitorRequest = {
    import CreateMonitorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CreateMonitorRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .displayName(ResourceName.unwrap(displayName): java.lang.String)
      .identityCenterInstanceArn(
        IdentityCenterInstanceArn.unwrap(
          identityCenterInstanceArn
        ): java.lang.String
      )
      .subdomain(Subdomain.unwrap(subdomain): java.lang.String)
      .roleArn(IamRoleArn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.CreateMonitorRequest.ReadOnly =
    zio.aws.deadline.model.CreateMonitorRequest.wrap(buildAwsValue())
}
object CreateMonitorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CreateMonitorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CreateMonitorRequest =
      zio.aws.deadline.model.CreateMonitorRequest(
        clientToken.map(value => value),
        displayName,
        identityCenterInstanceArn,
        subdomain,
        roleArn
      )
    def clientToken: Optional[ClientToken]
    def displayName: ResourceName
    def identityCenterInstanceArn: IdentityCenterInstanceArn
    def subdomain: Subdomain
    def roleArn: IamRoleArn
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDisplayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(displayName)
    def getIdentityCenterInstanceArn
        : ZIO[Any, Nothing, IdentityCenterInstanceArn] =
      ZIO.succeed(identityCenterInstanceArn)
    def getSubdomain: ZIO[Any, Nothing, Subdomain] = ZIO.succeed(subdomain)
    def getRoleArn: ZIO[Any, Nothing, IamRoleArn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CreateMonitorRequest
  ) extends zio.aws.deadline.model.CreateMonitorRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.deadline.model.primitives.ClientToken(value))
    override val displayName: ResourceName =
      zio.aws.deadline.model.primitives.ResourceName(impl.displayName())
    override val identityCenterInstanceArn: IdentityCenterInstanceArn =
      zio.aws.deadline.model.primitives
        .IdentityCenterInstanceArn(impl.identityCenterInstanceArn())
    override val subdomain: Subdomain =
      zio.aws.deadline.model.primitives.Subdomain(impl.subdomain())
    override val roleArn: IamRoleArn =
      zio.aws.deadline.model.primitives.IamRoleArn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CreateMonitorRequest
  ): zio.aws.deadline.model.CreateMonitorRequest.ReadOnly = new Wrapper(impl)
}
