package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  IdentityCenterApplicationArn,
  MonitorId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateMonitorResponse(
    monitorId: MonitorId,
    identityCenterApplicationArn: IdentityCenterApplicationArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CreateMonitorResponse = {
    import CreateMonitorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CreateMonitorResponse
      .builder()
      .monitorId(MonitorId.unwrap(monitorId): java.lang.String)
      .identityCenterApplicationArn(
        IdentityCenterApplicationArn.unwrap(
          identityCenterApplicationArn
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.CreateMonitorResponse.ReadOnly =
    zio.aws.deadline.model.CreateMonitorResponse.wrap(buildAwsValue())
}
object CreateMonitorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CreateMonitorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CreateMonitorResponse =
      zio.aws.deadline.model
        .CreateMonitorResponse(monitorId, identityCenterApplicationArn)
    def monitorId: MonitorId
    def identityCenterApplicationArn: IdentityCenterApplicationArn
    def getMonitorId: ZIO[Any, Nothing, MonitorId] = ZIO.succeed(monitorId)
    def getIdentityCenterApplicationArn
        : ZIO[Any, Nothing, IdentityCenterApplicationArn] =
      ZIO.succeed(identityCenterApplicationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CreateMonitorResponse
  ) extends zio.aws.deadline.model.CreateMonitorResponse.ReadOnly {
    override val monitorId: MonitorId =
      zio.aws.deadline.model.primitives.MonitorId(impl.monitorId())
    override val identityCenterApplicationArn: IdentityCenterApplicationArn =
      zio.aws.deadline.model.primitives
        .IdentityCenterApplicationArn(impl.identityCenterApplicationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CreateMonitorResponse
  ): zio.aws.deadline.model.CreateMonitorResponse.ReadOnly = new Wrapper(impl)
}
