package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  QueueId,
  FarmId,
  Priority,
  ClientToken,
  EnvironmentTemplate
}
import scala.jdk.CollectionConverters._
final case class CreateQueueEnvironmentRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    farmId: FarmId,
    queueId: QueueId,
    priority: Priority,
    templateType: zio.aws.deadline.model.EnvironmentTemplateType,
    template: EnvironmentTemplate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CreateQueueEnvironmentRequest = {
    import CreateQueueEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CreateQueueEnvironmentRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .priority(Priority.unwrap(priority): Integer)
      .templateType(templateType.unwrap)
      .template(EnvironmentTemplate.unwrap(template): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.CreateQueueEnvironmentRequest.ReadOnly =
    zio.aws.deadline.model.CreateQueueEnvironmentRequest.wrap(buildAwsValue())
}
object CreateQueueEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CreateQueueEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CreateQueueEnvironmentRequest =
      zio.aws.deadline.model.CreateQueueEnvironmentRequest(
        clientToken.map(value => value),
        farmId,
        queueId,
        priority,
        templateType,
        template
      )
    def clientToken: Optional[ClientToken]
    def farmId: FarmId
    def queueId: QueueId
    def priority: Priority
    def templateType: zio.aws.deadline.model.EnvironmentTemplateType
    def template: EnvironmentTemplate
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getPriority: ZIO[Any, Nothing, Priority] = ZIO.succeed(priority)
    def getTemplateType
        : ZIO[Any, Nothing, zio.aws.deadline.model.EnvironmentTemplateType] =
      ZIO.succeed(templateType)
    def getTemplate: ZIO[Any, Nothing, EnvironmentTemplate] =
      ZIO.succeed(template)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CreateQueueEnvironmentRequest
  ) extends zio.aws.deadline.model.CreateQueueEnvironmentRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.deadline.model.primitives.ClientToken(value))
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val priority: Priority =
      zio.aws.deadline.model.primitives.Priority(impl.priority())
    override val templateType: zio.aws.deadline.model.EnvironmentTemplateType =
      zio.aws.deadline.model.EnvironmentTemplateType.wrap(impl.templateType())
    override val template: EnvironmentTemplate =
      zio.aws.deadline.model.primitives.EnvironmentTemplate(impl.template())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CreateQueueEnvironmentRequest
  ): zio.aws.deadline.model.CreateQueueEnvironmentRequest.ReadOnly =
    new Wrapper(impl)
}
