package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.QueueEnvironmentId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateQueueEnvironmentResponse(
    queueEnvironmentId: QueueEnvironmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CreateQueueEnvironmentResponse = {
    import CreateQueueEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CreateQueueEnvironmentResponse
      .builder()
      .queueEnvironmentId(
        QueueEnvironmentId.unwrap(queueEnvironmentId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.CreateQueueEnvironmentResponse.ReadOnly =
    zio.aws.deadline.model.CreateQueueEnvironmentResponse.wrap(buildAwsValue())
}
object CreateQueueEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CreateQueueEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CreateQueueEnvironmentResponse =
      zio.aws.deadline.model.CreateQueueEnvironmentResponse(queueEnvironmentId)
    def queueEnvironmentId: QueueEnvironmentId
    def getQueueEnvironmentId: ZIO[Any, Nothing, QueueEnvironmentId] =
      ZIO.succeed(queueEnvironmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CreateQueueEnvironmentResponse
  ) extends zio.aws.deadline.model.CreateQueueEnvironmentResponse.ReadOnly {
    override val queueEnvironmentId: QueueEnvironmentId =
      zio.aws.deadline.model.primitives
        .QueueEnvironmentId(impl.queueEnvironmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CreateQueueEnvironmentResponse
  ): zio.aws.deadline.model.CreateQueueEnvironmentResponse.ReadOnly =
    new Wrapper(impl)
}
