package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{FleetId, QueueId, FarmId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateQueueFleetAssociationRequest(
    farmId: FarmId,
    queueId: QueueId,
    fleetId: FleetId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CreateQueueFleetAssociationRequest = {
    import CreateQueueFleetAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CreateQueueFleetAssociationRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.CreateQueueFleetAssociationRequest.ReadOnly =
    zio.aws.deadline.model.CreateQueueFleetAssociationRequest
      .wrap(buildAwsValue())
}
object CreateQueueFleetAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CreateQueueFleetAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CreateQueueFleetAssociationRequest =
      zio.aws.deadline.model
        .CreateQueueFleetAssociationRequest(farmId, queueId, fleetId)
    def farmId: FarmId
    def queueId: QueueId
    def fleetId: FleetId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CreateQueueFleetAssociationRequest
  ) extends zio.aws.deadline.model.CreateQueueFleetAssociationRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val fleetId: FleetId =
      zio.aws.deadline.model.primitives.FleetId(impl.fleetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CreateQueueFleetAssociationRequest
  ): zio.aws.deadline.model.CreateQueueFleetAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
