package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  IamRoleArn,
  FarmId,
  FileSystemLocationName,
  StorageProfileId,
  Description,
  ClientToken,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateQueueRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    farmId: FarmId,
    displayName: ResourceName,
    description: Optional[Description] = Optional.Absent,
    defaultBudgetAction: Optional[
      zio.aws.deadline.model.DefaultQueueBudgetAction
    ] = Optional.Absent,
    jobAttachmentSettings: Optional[
      zio.aws.deadline.model.JobAttachmentSettings
    ] = Optional.Absent,
    roleArn: Optional[IamRoleArn] = Optional.Absent,
    jobRunAsUser: Optional[zio.aws.deadline.model.JobRunAsUser] =
      Optional.Absent,
    requiredFileSystemLocationNames: Optional[
      Iterable[FileSystemLocationName]
    ] = Optional.Absent,
    allowedStorageProfileIds: Optional[Iterable[StorageProfileId]] =
      Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CreateQueueRequest = {
    import CreateQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CreateQueueRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .displayName(ResourceName.unwrap(displayName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(defaultBudgetAction.map(value => value.unwrap))(
        _.defaultBudgetAction
      )
      .optionallyWith(
        jobAttachmentSettings.map(value => value.buildAwsValue())
      )(_.jobAttachmentSettings)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(jobRunAsUser.map(value => value.buildAwsValue()))(
        _.jobRunAsUser
      )
      .optionallyWith(
        requiredFileSystemLocationNames.map(value =>
          value.map { item =>
            FileSystemLocationName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.requiredFileSystemLocationNames)
      .optionallyWith(
        allowedStorageProfileIds.map(value =>
          value.map { item =>
            StorageProfileId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allowedStorageProfileIds)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.CreateQueueRequest.ReadOnly =
    zio.aws.deadline.model.CreateQueueRequest.wrap(buildAwsValue())
}
object CreateQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CreateQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CreateQueueRequest =
      zio.aws.deadline.model.CreateQueueRequest(
        clientToken.map(value => value),
        farmId,
        displayName,
        description.map(value => value),
        defaultBudgetAction.map(value => value),
        jobAttachmentSettings.map(value => value.asEditable),
        roleArn.map(value => value),
        jobRunAsUser.map(value => value.asEditable),
        requiredFileSystemLocationNames.map(value => value),
        allowedStorageProfileIds.map(value => value),
        tags.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def farmId: FarmId
    def displayName: ResourceName
    def description: Optional[Description]
    def defaultBudgetAction
        : Optional[zio.aws.deadline.model.DefaultQueueBudgetAction]
    def jobAttachmentSettings
        : Optional[zio.aws.deadline.model.JobAttachmentSettings.ReadOnly]
    def roleArn: Optional[IamRoleArn]
    def jobRunAsUser: Optional[zio.aws.deadline.model.JobRunAsUser.ReadOnly]
    def requiredFileSystemLocationNames: Optional[List[FileSystemLocationName]]
    def allowedStorageProfileIds: Optional[List[StorageProfileId]]
    def tags: Optional[Map[String, String]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getDisplayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(displayName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDefaultBudgetAction
        : ZIO[Any, AwsError, zio.aws.deadline.model.DefaultQueueBudgetAction] =
      AwsError.unwrapOptionField("defaultBudgetAction", defaultBudgetAction)
    def getJobAttachmentSettings: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.JobAttachmentSettings.ReadOnly
    ] =
      AwsError.unwrapOptionField("jobAttachmentSettings", jobAttachmentSettings)
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getJobRunAsUser
        : ZIO[Any, AwsError, zio.aws.deadline.model.JobRunAsUser.ReadOnly] =
      AwsError.unwrapOptionField("jobRunAsUser", jobRunAsUser)
    def getRequiredFileSystemLocationNames
        : ZIO[Any, AwsError, List[FileSystemLocationName]] =
      AwsError.unwrapOptionField(
        "requiredFileSystemLocationNames",
        requiredFileSystemLocationNames
      )
    def getAllowedStorageProfileIds
        : ZIO[Any, AwsError, List[StorageProfileId]] = AwsError
      .unwrapOptionField("allowedStorageProfileIds", allowedStorageProfileIds)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CreateQueueRequest
  ) extends zio.aws.deadline.model.CreateQueueRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.deadline.model.primitives.ClientToken(value))
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val displayName: ResourceName =
      zio.aws.deadline.model.primitives.ResourceName(impl.displayName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.deadline.model.primitives.Description(value))
    override val defaultBudgetAction
        : Optional[zio.aws.deadline.model.DefaultQueueBudgetAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultBudgetAction())
        .map(value =>
          zio.aws.deadline.model.DefaultQueueBudgetAction.wrap(value)
        )
    override val jobAttachmentSettings
        : Optional[zio.aws.deadline.model.JobAttachmentSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobAttachmentSettings())
        .map(value => zio.aws.deadline.model.JobAttachmentSettings.wrap(value))
    override val roleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.deadline.model.primitives.IamRoleArn(value))
    override val jobRunAsUser
        : Optional[zio.aws.deadline.model.JobRunAsUser.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobRunAsUser())
        .map(value => zio.aws.deadline.model.JobRunAsUser.wrap(value))
    override val requiredFileSystemLocationNames
        : Optional[List[FileSystemLocationName]] = zio.aws.core.internal
      .optionalFromNullable(impl.requiredFileSystemLocationNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.deadline.model.primitives.FileSystemLocationName(item)
        }.toList
      )
    override val allowedStorageProfileIds: Optional[List[StorageProfileId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowedStorageProfileIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.primitives.StorageProfileId(item)
          }.toList
        )
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CreateQueueRequest
  ): zio.aws.deadline.model.CreateQueueRequest.ReadOnly = new Wrapper(impl)
}
