package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.QueueId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateQueueResponse(queueId: QueueId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CreateQueueResponse = {
    import CreateQueueResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CreateQueueResponse
      .builder()
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.CreateQueueResponse.ReadOnly =
    zio.aws.deadline.model.CreateQueueResponse.wrap(buildAwsValue())
}
object CreateQueueResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CreateQueueResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CreateQueueResponse =
      zio.aws.deadline.model.CreateQueueResponse(queueId)
    def queueId: QueueId
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CreateQueueResponse
  ) extends zio.aws.deadline.model.CreateQueueResponse.ReadOnly {
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CreateQueueResponse
  ): zio.aws.deadline.model.CreateQueueResponse.ReadOnly = new Wrapper(impl)
}
