package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{ResourceName, FarmId, ClientToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateStorageProfileRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    farmId: FarmId,
    displayName: ResourceName,
    osFamily: zio.aws.deadline.model.StorageProfileOperatingSystemFamily,
    fileSystemLocations: Optional[
      Iterable[zio.aws.deadline.model.FileSystemLocation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CreateStorageProfileRequest = {
    import CreateStorageProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CreateStorageProfileRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .displayName(ResourceName.unwrap(displayName): java.lang.String)
      .osFamily(osFamily.unwrap)
      .optionallyWith(
        fileSystemLocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystemLocations)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.CreateStorageProfileRequest.ReadOnly =
    zio.aws.deadline.model.CreateStorageProfileRequest.wrap(buildAwsValue())
}
object CreateStorageProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CreateStorageProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CreateStorageProfileRequest =
      zio.aws.deadline.model.CreateStorageProfileRequest(
        clientToken.map(value => value),
        farmId,
        displayName,
        osFamily,
        fileSystemLocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientToken: Optional[ClientToken]
    def farmId: FarmId
    def displayName: ResourceName
    def osFamily: zio.aws.deadline.model.StorageProfileOperatingSystemFamily
    def fileSystemLocations
        : Optional[List[zio.aws.deadline.model.FileSystemLocation.ReadOnly]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getDisplayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(displayName)
    def getOsFamily: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.StorageProfileOperatingSystemFamily
    ] = ZIO.succeed(osFamily)
    def getFileSystemLocations: ZIO[Any, AwsError, List[
      zio.aws.deadline.model.FileSystemLocation.ReadOnly
    ]] = AwsError.unwrapOptionField("fileSystemLocations", fileSystemLocations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CreateStorageProfileRequest
  ) extends zio.aws.deadline.model.CreateStorageProfileRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.deadline.model.primitives.ClientToken(value))
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val displayName: ResourceName =
      zio.aws.deadline.model.primitives.ResourceName(impl.displayName())
    override val osFamily
        : zio.aws.deadline.model.StorageProfileOperatingSystemFamily =
      zio.aws.deadline.model.StorageProfileOperatingSystemFamily
        .wrap(impl.osFamily())
    override val fileSystemLocations
        : Optional[List[zio.aws.deadline.model.FileSystemLocation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSystemLocations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.FileSystemLocation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CreateStorageProfileRequest
  ): zio.aws.deadline.model.CreateStorageProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
