package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.StorageProfileId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateStorageProfileResponse(
    storageProfileId: StorageProfileId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CreateStorageProfileResponse = {
    import CreateStorageProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CreateStorageProfileResponse
      .builder()
      .storageProfileId(
        StorageProfileId.unwrap(storageProfileId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.CreateStorageProfileResponse.ReadOnly =
    zio.aws.deadline.model.CreateStorageProfileResponse.wrap(buildAwsValue())
}
object CreateStorageProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CreateStorageProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CreateStorageProfileResponse =
      zio.aws.deadline.model.CreateStorageProfileResponse(storageProfileId)
    def storageProfileId: StorageProfileId
    def getStorageProfileId: ZIO[Any, Nothing, StorageProfileId] =
      ZIO.succeed(storageProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CreateStorageProfileResponse
  ) extends zio.aws.deadline.model.CreateStorageProfileResponse.ReadOnly {
    override val storageProfileId: StorageProfileId =
      zio.aws.deadline.model.primitives
        .StorageProfileId(impl.storageProfileId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CreateStorageProfileResponse
  ): zio.aws.deadline.model.CreateStorageProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
