package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{ClientToken, FleetId, FarmId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateWorkerRequest(
    farmId: FarmId,
    fleetId: FleetId,
    hostProperties: Optional[zio.aws.deadline.model.HostPropertiesRequest] =
      Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CreateWorkerRequest = {
    import CreateWorkerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CreateWorkerRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .optionallyWith(hostProperties.map(value => value.buildAwsValue()))(
        _.hostProperties
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.CreateWorkerRequest.ReadOnly =
    zio.aws.deadline.model.CreateWorkerRequest.wrap(buildAwsValue())
}
object CreateWorkerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CreateWorkerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CreateWorkerRequest =
      zio.aws.deadline.model.CreateWorkerRequest(
        farmId,
        fleetId,
        hostProperties.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def farmId: FarmId
    def fleetId: FleetId
    def hostProperties
        : Optional[zio.aws.deadline.model.HostPropertiesRequest.ReadOnly]
    def clientToken: Optional[ClientToken]
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getHostProperties: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.HostPropertiesRequest.ReadOnly
    ] = AwsError.unwrapOptionField("hostProperties", hostProperties)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CreateWorkerRequest
  ) extends zio.aws.deadline.model.CreateWorkerRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val fleetId: FleetId =
      zio.aws.deadline.model.primitives.FleetId(impl.fleetId())
    override val hostProperties
        : Optional[zio.aws.deadline.model.HostPropertiesRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostProperties())
        .map(value => zio.aws.deadline.model.HostPropertiesRequest.wrap(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.deadline.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CreateWorkerRequest
  ): zio.aws.deadline.model.CreateWorkerRequest.ReadOnly = new Wrapper(impl)
}
