package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.WorkerId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateWorkerResponse(workerId: WorkerId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CreateWorkerResponse = {
    import CreateWorkerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CreateWorkerResponse
      .builder()
      .workerId(WorkerId.unwrap(workerId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.CreateWorkerResponse.ReadOnly =
    zio.aws.deadline.model.CreateWorkerResponse.wrap(buildAwsValue())
}
object CreateWorkerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CreateWorkerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CreateWorkerResponse =
      zio.aws.deadline.model.CreateWorkerResponse(workerId)
    def workerId: WorkerId
    def getWorkerId: ZIO[Any, Nothing, WorkerId] = ZIO.succeed(workerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CreateWorkerResponse
  ) extends zio.aws.deadline.model.CreateWorkerResponse.ReadOnly {
    override val workerId: WorkerId =
      zio.aws.deadline.model.primitives.WorkerId(impl.workerId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CreateWorkerResponse
  ): zio.aws.deadline.model.CreateWorkerResponse.ReadOnly = new Wrapper(impl)
}
