package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.StorageProfileId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CustomerManagedFleetConfiguration(
    mode: zio.aws.deadline.model.AutoScalingMode,
    workerCapabilities: zio.aws.deadline.model.CustomerManagedWorkerCapabilities,
    storageProfileId: Optional[StorageProfileId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CustomerManagedFleetConfiguration = {
    import CustomerManagedFleetConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CustomerManagedFleetConfiguration
      .builder()
      .mode(mode.unwrap)
      .workerCapabilities(workerCapabilities.buildAwsValue())
      .optionallyWith(
        storageProfileId.map(value =>
          StorageProfileId.unwrap(value): java.lang.String
        )
      )(_.storageProfileId)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.CustomerManagedFleetConfiguration.ReadOnly =
    zio.aws.deadline.model.CustomerManagedFleetConfiguration
      .wrap(buildAwsValue())
}
object CustomerManagedFleetConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CustomerManagedFleetConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CustomerManagedFleetConfiguration =
      zio.aws.deadline.model.CustomerManagedFleetConfiguration(
        mode,
        workerCapabilities.asEditable,
        storageProfileId.map(value => value)
      )
    def mode: zio.aws.deadline.model.AutoScalingMode
    def workerCapabilities
        : zio.aws.deadline.model.CustomerManagedWorkerCapabilities.ReadOnly
    def storageProfileId: Optional[StorageProfileId]
    def getMode: ZIO[Any, Nothing, zio.aws.deadline.model.AutoScalingMode] =
      ZIO.succeed(mode)
    def getWorkerCapabilities: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.CustomerManagedWorkerCapabilities.ReadOnly
    ] = ZIO.succeed(workerCapabilities)
    def getStorageProfileId: ZIO[Any, AwsError, StorageProfileId] =
      AwsError.unwrapOptionField("storageProfileId", storageProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CustomerManagedFleetConfiguration
  ) extends zio.aws.deadline.model.CustomerManagedFleetConfiguration.ReadOnly {
    override val mode: zio.aws.deadline.model.AutoScalingMode =
      zio.aws.deadline.model.AutoScalingMode.wrap(impl.mode())
    override val workerCapabilities
        : zio.aws.deadline.model.CustomerManagedWorkerCapabilities.ReadOnly =
      zio.aws.deadline.model.CustomerManagedWorkerCapabilities
        .wrap(impl.workerCapabilities())
    override val storageProfileId: Optional[StorageProfileId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageProfileId())
        .map(value => zio.aws.deadline.model.primitives.StorageProfileId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CustomerManagedFleetConfiguration
  ): zio.aws.deadline.model.CustomerManagedFleetConfiguration.ReadOnly =
    new Wrapper(impl)
}
