package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CustomerManagedWorkerCapabilities(
    vCpuCount: zio.aws.deadline.model.VCpuCountRange,
    memoryMiB: zio.aws.deadline.model.MemoryMiBRange,
    acceleratorTypes: Optional[
      Iterable[zio.aws.deadline.model.AcceleratorType]
    ] = Optional.Absent,
    acceleratorCount: Optional[zio.aws.deadline.model.AcceleratorCountRange] =
      Optional.Absent,
    acceleratorTotalMemoryMiB: Optional[
      zio.aws.deadline.model.AcceleratorTotalMemoryMiBRange
    ] = Optional.Absent,
    osFamily: zio.aws.deadline.model.CustomerManagedFleetOperatingSystemFamily,
    cpuArchitectureType: zio.aws.deadline.model.CpuArchitectureType,
    customAmounts: Optional[
      Iterable[zio.aws.deadline.model.FleetAmountCapability]
    ] = Optional.Absent,
    customAttributes: Optional[
      Iterable[zio.aws.deadline.model.FleetAttributeCapability]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.CustomerManagedWorkerCapabilities = {
    import CustomerManagedWorkerCapabilities.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.CustomerManagedWorkerCapabilities
      .builder()
      .vCpuCount(vCpuCount.buildAwsValue())
      .memoryMiB(memoryMiB.buildAwsValue())
      .optionallyWith(
        acceleratorTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.acceleratorTypesWithStrings)
      .optionallyWith(acceleratorCount.map(value => value.buildAwsValue()))(
        _.acceleratorCount
      )
      .optionallyWith(
        acceleratorTotalMemoryMiB.map(value => value.buildAwsValue())
      )(_.acceleratorTotalMemoryMiB)
      .osFamily(osFamily.unwrap)
      .cpuArchitectureType(cpuArchitectureType.unwrap)
      .optionallyWith(
        customAmounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customAmounts)
      .optionallyWith(
        customAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.CustomerManagedWorkerCapabilities.ReadOnly =
    zio.aws.deadline.model.CustomerManagedWorkerCapabilities
      .wrap(buildAwsValue())
}
object CustomerManagedWorkerCapabilities {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.CustomerManagedWorkerCapabilities
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.CustomerManagedWorkerCapabilities =
      zio.aws.deadline.model.CustomerManagedWorkerCapabilities(
        vCpuCount.asEditable,
        memoryMiB.asEditable,
        acceleratorTypes.map(value => value),
        acceleratorCount.map(value => value.asEditable),
        acceleratorTotalMemoryMiB.map(value => value.asEditable),
        osFamily,
        cpuArchitectureType,
        customAmounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def vCpuCount: zio.aws.deadline.model.VCpuCountRange.ReadOnly
    def memoryMiB: zio.aws.deadline.model.MemoryMiBRange.ReadOnly
    def acceleratorTypes: Optional[List[zio.aws.deadline.model.AcceleratorType]]
    def acceleratorCount
        : Optional[zio.aws.deadline.model.AcceleratorCountRange.ReadOnly]
    def acceleratorTotalMemoryMiB: Optional[
      zio.aws.deadline.model.AcceleratorTotalMemoryMiBRange.ReadOnly
    ]
    def osFamily
        : zio.aws.deadline.model.CustomerManagedFleetOperatingSystemFamily
    def cpuArchitectureType: zio.aws.deadline.model.CpuArchitectureType
    def customAmounts
        : Optional[List[zio.aws.deadline.model.FleetAmountCapability.ReadOnly]]
    def customAttributes: Optional[
      List[zio.aws.deadline.model.FleetAttributeCapability.ReadOnly]
    ]
    def getVCpuCount
        : ZIO[Any, Nothing, zio.aws.deadline.model.VCpuCountRange.ReadOnly] =
      ZIO.succeed(vCpuCount)
    def getMemoryMiB
        : ZIO[Any, Nothing, zio.aws.deadline.model.MemoryMiBRange.ReadOnly] =
      ZIO.succeed(memoryMiB)
    def getAcceleratorTypes
        : ZIO[Any, AwsError, List[zio.aws.deadline.model.AcceleratorType]] =
      AwsError.unwrapOptionField("acceleratorTypes", acceleratorTypes)
    def getAcceleratorCount: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.AcceleratorCountRange.ReadOnly
    ] = AwsError.unwrapOptionField("acceleratorCount", acceleratorCount)
    def getAcceleratorTotalMemoryMiB: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.AcceleratorTotalMemoryMiBRange.ReadOnly
    ] = AwsError.unwrapOptionField(
      "acceleratorTotalMemoryMiB",
      acceleratorTotalMemoryMiB
    )
    def getOsFamily: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.CustomerManagedFleetOperatingSystemFamily
    ] = ZIO.succeed(osFamily)
    def getCpuArchitectureType
        : ZIO[Any, Nothing, zio.aws.deadline.model.CpuArchitectureType] =
      ZIO.succeed(cpuArchitectureType)
    def getCustomAmounts: ZIO[Any, AwsError, List[
      zio.aws.deadline.model.FleetAmountCapability.ReadOnly
    ]] = AwsError.unwrapOptionField("customAmounts", customAmounts)
    def getCustomAttributes: ZIO[Any, AwsError, List[
      zio.aws.deadline.model.FleetAttributeCapability.ReadOnly
    ]] = AwsError.unwrapOptionField("customAttributes", customAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.CustomerManagedWorkerCapabilities
  ) extends zio.aws.deadline.model.CustomerManagedWorkerCapabilities.ReadOnly {
    override val vCpuCount: zio.aws.deadline.model.VCpuCountRange.ReadOnly =
      zio.aws.deadline.model.VCpuCountRange.wrap(impl.vCpuCount())
    override val memoryMiB: zio.aws.deadline.model.MemoryMiBRange.ReadOnly =
      zio.aws.deadline.model.MemoryMiBRange.wrap(impl.memoryMiB())
    override val acceleratorTypes
        : Optional[List[zio.aws.deadline.model.AcceleratorType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceleratorTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.AcceleratorType.wrap(item)
          }.toList
        )
    override val acceleratorCount
        : Optional[zio.aws.deadline.model.AcceleratorCountRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceleratorCount())
        .map(value => zio.aws.deadline.model.AcceleratorCountRange.wrap(value))
    override val acceleratorTotalMemoryMiB: Optional[
      zio.aws.deadline.model.AcceleratorTotalMemoryMiBRange.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.acceleratorTotalMemoryMiB())
      .map(value =>
        zio.aws.deadline.model.AcceleratorTotalMemoryMiBRange.wrap(value)
      )
    override val osFamily
        : zio.aws.deadline.model.CustomerManagedFleetOperatingSystemFamily =
      zio.aws.deadline.model.CustomerManagedFleetOperatingSystemFamily
        .wrap(impl.osFamily())
    override val cpuArchitectureType
        : zio.aws.deadline.model.CpuArchitectureType =
      zio.aws.deadline.model.CpuArchitectureType
        .wrap(impl.cpuArchitectureType())
    override val customAmounts: Optional[
      List[zio.aws.deadline.model.FleetAmountCapability.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customAmounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.deadline.model.FleetAmountCapability.wrap(item)
        }.toList
      )
    override val customAttributes: Optional[
      List[zio.aws.deadline.model.FleetAttributeCapability.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.deadline.model.FleetAttributeCapability.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.CustomerManagedWorkerCapabilities
  ): zio.aws.deadline.model.CustomerManagedWorkerCapabilities.ReadOnly =
    new Wrapper(impl)
}
