package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.SyntheticTimestamp_date_time
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DateTimeFilterExpression(
    name: String,
    operator: zio.aws.deadline.model.ComparisonOperator,
    dateTime: SyntheticTimestamp_date_time
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.DateTimeFilterExpression = {
    import DateTimeFilterExpression.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.DateTimeFilterExpression
      .builder()
      .name(name: java.lang.String)
      .operator(operator.unwrap)
      .dateTime(SyntheticTimestamp_date_time.unwrap(dateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.DateTimeFilterExpression.ReadOnly =
    zio.aws.deadline.model.DateTimeFilterExpression.wrap(buildAwsValue())
}
object DateTimeFilterExpression {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.DateTimeFilterExpression
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.DateTimeFilterExpression =
      zio.aws.deadline.model.DateTimeFilterExpression(name, operator, dateTime)
    def name: String
    def operator: zio.aws.deadline.model.ComparisonOperator
    def dateTime: SyntheticTimestamp_date_time
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getOperator
        : ZIO[Any, Nothing, zio.aws.deadline.model.ComparisonOperator] =
      ZIO.succeed(operator)
    def getDateTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(dateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.DateTimeFilterExpression
  ) extends zio.aws.deadline.model.DateTimeFilterExpression.ReadOnly {
    override val name: String = impl.name(): String
    override val operator: zio.aws.deadline.model.ComparisonOperator =
      zio.aws.deadline.model.ComparisonOperator.wrap(impl.operator())
    override val dateTime: SyntheticTimestamp_date_time =
      zio.aws.deadline.model.primitives
        .SyntheticTimestamp_date_time(impl.dateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.DateTimeFilterExpression
  ): zio.aws.deadline.model.DateTimeFilterExpression.ReadOnly = new Wrapper(
    impl
  )
}
