package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait DefaultQueueBudgetAction {
  def unwrap
      : software.amazon.awssdk.services.deadline.model.DefaultQueueBudgetAction
}
object DefaultQueueBudgetAction {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.DefaultQueueBudgetAction
  ): zio.aws.deadline.model.DefaultQueueBudgetAction = value match {
    case software.amazon.awssdk.services.deadline.model.DefaultQueueBudgetAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.DefaultQueueBudgetAction.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.deadline.model.DefaultQueueBudgetAction.STOP_SCHEDULING_AND_COMPLETE_TASKS =>
      val r = STOP_SCHEDULING_AND_COMPLETE_TASKS
      r
    case software.amazon.awssdk.services.deadline.model.DefaultQueueBudgetAction.STOP_SCHEDULING_AND_CANCEL_TASKS =>
      val r = STOP_SCHEDULING_AND_CANCEL_TASKS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.DefaultQueueBudgetAction {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.DefaultQueueBudgetAction =
      software.amazon.awssdk.services.deadline.model.DefaultQueueBudgetAction.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.deadline.model.DefaultQueueBudgetAction {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.DefaultQueueBudgetAction =
      software.amazon.awssdk.services.deadline.model.DefaultQueueBudgetAction.NONE
  }
  case object STOP_SCHEDULING_AND_COMPLETE_TASKS
      extends zio.aws.deadline.model.DefaultQueueBudgetAction {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.DefaultQueueBudgetAction =
      software.amazon.awssdk.services.deadline.model.DefaultQueueBudgetAction.STOP_SCHEDULING_AND_COMPLETE_TASKS
  }
  case object STOP_SCHEDULING_AND_CANCEL_TASKS
      extends zio.aws.deadline.model.DefaultQueueBudgetAction {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.DefaultQueueBudgetAction =
      software.amazon.awssdk.services.deadline.model.DefaultQueueBudgetAction.STOP_SCHEDULING_AND_CANCEL_TASKS
  }
}
