package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{BudgetId, FarmId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteBudgetRequest(farmId: FarmId, budgetId: BudgetId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.DeleteBudgetRequest = {
    import DeleteBudgetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.DeleteBudgetRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .budgetId(BudgetId.unwrap(budgetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.DeleteBudgetRequest.ReadOnly =
    zio.aws.deadline.model.DeleteBudgetRequest.wrap(buildAwsValue())
}
object DeleteBudgetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.DeleteBudgetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.DeleteBudgetRequest =
      zio.aws.deadline.model.DeleteBudgetRequest(farmId, budgetId)
    def farmId: FarmId
    def budgetId: BudgetId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getBudgetId: ZIO[Any, Nothing, BudgetId] = ZIO.succeed(budgetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.DeleteBudgetRequest
  ) extends zio.aws.deadline.model.DeleteBudgetRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val budgetId: BudgetId =
      zio.aws.deadline.model.primitives.BudgetId(impl.budgetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.DeleteBudgetRequest
  ): zio.aws.deadline.model.DeleteBudgetRequest.ReadOnly = new Wrapper(impl)
}
