package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.FarmId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteFarmRequest(farmId: FarmId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.DeleteFarmRequest = {
    import DeleteFarmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.DeleteFarmRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.DeleteFarmRequest.ReadOnly =
    zio.aws.deadline.model.DeleteFarmRequest.wrap(buildAwsValue())
}
object DeleteFarmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.DeleteFarmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.DeleteFarmRequest =
      zio.aws.deadline.model.DeleteFarmRequest(farmId)
    def farmId: FarmId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.DeleteFarmRequest
  ) extends zio.aws.deadline.model.DeleteFarmRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.DeleteFarmRequest
  ): zio.aws.deadline.model.DeleteFarmRequest.ReadOnly = new Wrapper(impl)
}
