package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{FleetId, FarmId, ClientToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteFleetRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    farmId: FarmId,
    fleetId: FleetId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.DeleteFleetRequest = {
    import DeleteFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.DeleteFleetRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.DeleteFleetRequest.ReadOnly =
    zio.aws.deadline.model.DeleteFleetRequest.wrap(buildAwsValue())
}
object DeleteFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.DeleteFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.DeleteFleetRequest =
      zio.aws.deadline.model
        .DeleteFleetRequest(clientToken.map(value => value), farmId, fleetId)
    def clientToken: Optional[ClientToken]
    def farmId: FarmId
    def fleetId: FleetId
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.DeleteFleetRequest
  ) extends zio.aws.deadline.model.DeleteFleetRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.deadline.model.primitives.ClientToken(value))
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val fleetId: FleetId =
      zio.aws.deadline.model.primitives.FleetId(impl.fleetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.DeleteFleetRequest
  ): zio.aws.deadline.model.DeleteFleetRequest.ReadOnly = new Wrapper(impl)
}
