package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.LicenseEndpointId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteLicenseEndpointRequest(
    licenseEndpointId: LicenseEndpointId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.DeleteLicenseEndpointRequest = {
    import DeleteLicenseEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.DeleteLicenseEndpointRequest
      .builder()
      .licenseEndpointId(
        LicenseEndpointId.unwrap(licenseEndpointId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.DeleteLicenseEndpointRequest.ReadOnly =
    zio.aws.deadline.model.DeleteLicenseEndpointRequest.wrap(buildAwsValue())
}
object DeleteLicenseEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.DeleteLicenseEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.DeleteLicenseEndpointRequest =
      zio.aws.deadline.model.DeleteLicenseEndpointRequest(licenseEndpointId)
    def licenseEndpointId: LicenseEndpointId
    def getLicenseEndpointId: ZIO[Any, Nothing, LicenseEndpointId] =
      ZIO.succeed(licenseEndpointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.DeleteLicenseEndpointRequest
  ) extends zio.aws.deadline.model.DeleteLicenseEndpointRequest.ReadOnly {
    override val licenseEndpointId: LicenseEndpointId =
      zio.aws.deadline.model.primitives
        .LicenseEndpointId(impl.licenseEndpointId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.DeleteLicenseEndpointRequest
  ): zio.aws.deadline.model.DeleteLicenseEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
