package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{MeteredProductId, LicenseEndpointId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteMeteredProductRequest(
    licenseEndpointId: LicenseEndpointId,
    productId: MeteredProductId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.DeleteMeteredProductRequest = {
    import DeleteMeteredProductRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.DeleteMeteredProductRequest
      .builder()
      .licenseEndpointId(
        LicenseEndpointId.unwrap(licenseEndpointId): java.lang.String
      )
      .productId(MeteredProductId.unwrap(productId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.DeleteMeteredProductRequest.ReadOnly =
    zio.aws.deadline.model.DeleteMeteredProductRequest.wrap(buildAwsValue())
}
object DeleteMeteredProductRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.DeleteMeteredProductRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.DeleteMeteredProductRequest =
      zio.aws.deadline.model
        .DeleteMeteredProductRequest(licenseEndpointId, productId)
    def licenseEndpointId: LicenseEndpointId
    def productId: MeteredProductId
    def getLicenseEndpointId: ZIO[Any, Nothing, LicenseEndpointId] =
      ZIO.succeed(licenseEndpointId)
    def getProductId: ZIO[Any, Nothing, MeteredProductId] =
      ZIO.succeed(productId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.DeleteMeteredProductRequest
  ) extends zio.aws.deadline.model.DeleteMeteredProductRequest.ReadOnly {
    override val licenseEndpointId: LicenseEndpointId =
      zio.aws.deadline.model.primitives
        .LicenseEndpointId(impl.licenseEndpointId())
    override val productId: MeteredProductId =
      zio.aws.deadline.model.primitives.MeteredProductId(impl.productId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.DeleteMeteredProductRequest
  ): zio.aws.deadline.model.DeleteMeteredProductRequest.ReadOnly = new Wrapper(
    impl
  )
}
