package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.MonitorId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteMonitorRequest(monitorId: MonitorId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.DeleteMonitorRequest = {
    import DeleteMonitorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.DeleteMonitorRequest
      .builder()
      .monitorId(MonitorId.unwrap(monitorId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.DeleteMonitorRequest.ReadOnly =
    zio.aws.deadline.model.DeleteMonitorRequest.wrap(buildAwsValue())
}
object DeleteMonitorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.DeleteMonitorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.DeleteMonitorRequest =
      zio.aws.deadline.model.DeleteMonitorRequest(monitorId)
    def monitorId: MonitorId
    def getMonitorId: ZIO[Any, Nothing, MonitorId] = ZIO.succeed(monitorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.DeleteMonitorRequest
  ) extends zio.aws.deadline.model.DeleteMonitorRequest.ReadOnly {
    override val monitorId: MonitorId =
      zio.aws.deadline.model.primitives.MonitorId(impl.monitorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.DeleteMonitorRequest
  ): zio.aws.deadline.model.DeleteMonitorRequest.ReadOnly = new Wrapper(impl)
}
