package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{QueueEnvironmentId, QueueId, FarmId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteQueueEnvironmentRequest(
    farmId: FarmId,
    queueId: QueueId,
    queueEnvironmentId: QueueEnvironmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.DeleteQueueEnvironmentRequest = {
    import DeleteQueueEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.DeleteQueueEnvironmentRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .queueEnvironmentId(
        QueueEnvironmentId.unwrap(queueEnvironmentId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.DeleteQueueEnvironmentRequest.ReadOnly =
    zio.aws.deadline.model.DeleteQueueEnvironmentRequest.wrap(buildAwsValue())
}
object DeleteQueueEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.DeleteQueueEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.DeleteQueueEnvironmentRequest =
      zio.aws.deadline.model
        .DeleteQueueEnvironmentRequest(farmId, queueId, queueEnvironmentId)
    def farmId: FarmId
    def queueId: QueueId
    def queueEnvironmentId: QueueEnvironmentId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getQueueEnvironmentId: ZIO[Any, Nothing, QueueEnvironmentId] =
      ZIO.succeed(queueEnvironmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.DeleteQueueEnvironmentRequest
  ) extends zio.aws.deadline.model.DeleteQueueEnvironmentRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val queueEnvironmentId: QueueEnvironmentId =
      zio.aws.deadline.model.primitives
        .QueueEnvironmentId(impl.queueEnvironmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.DeleteQueueEnvironmentRequest
  ): zio.aws.deadline.model.DeleteQueueEnvironmentRequest.ReadOnly =
    new Wrapper(impl)
}
