package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{FleetId, QueueId, FarmId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteQueueFleetAssociationRequest(
    farmId: FarmId,
    queueId: QueueId,
    fleetId: FleetId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.DeleteQueueFleetAssociationRequest = {
    import DeleteQueueFleetAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.DeleteQueueFleetAssociationRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.DeleteQueueFleetAssociationRequest.ReadOnly =
    zio.aws.deadline.model.DeleteQueueFleetAssociationRequest
      .wrap(buildAwsValue())
}
object DeleteQueueFleetAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.DeleteQueueFleetAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.DeleteQueueFleetAssociationRequest =
      zio.aws.deadline.model
        .DeleteQueueFleetAssociationRequest(farmId, queueId, fleetId)
    def farmId: FarmId
    def queueId: QueueId
    def fleetId: FleetId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.DeleteQueueFleetAssociationRequest
  ) extends zio.aws.deadline.model.DeleteQueueFleetAssociationRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val fleetId: FleetId =
      zio.aws.deadline.model.primitives.FleetId(impl.fleetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.DeleteQueueFleetAssociationRequest
  ): zio.aws.deadline.model.DeleteQueueFleetAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
