package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{QueueId, FarmId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteQueueRequest(farmId: FarmId, queueId: QueueId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.DeleteQueueRequest = {
    import DeleteQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.DeleteQueueRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.DeleteQueueRequest.ReadOnly =
    zio.aws.deadline.model.DeleteQueueRequest.wrap(buildAwsValue())
}
object DeleteQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.DeleteQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.DeleteQueueRequest =
      zio.aws.deadline.model.DeleteQueueRequest(farmId, queueId)
    def farmId: FarmId
    def queueId: QueueId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.DeleteQueueRequest
  ) extends zio.aws.deadline.model.DeleteQueueRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.DeleteQueueRequest
  ): zio.aws.deadline.model.DeleteQueueRequest.ReadOnly = new Wrapper(impl)
}
