package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{StorageProfileId, FarmId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteStorageProfileRequest(
    farmId: FarmId,
    storageProfileId: StorageProfileId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.DeleteStorageProfileRequest = {
    import DeleteStorageProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.DeleteStorageProfileRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .storageProfileId(
        StorageProfileId.unwrap(storageProfileId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.DeleteStorageProfileRequest.ReadOnly =
    zio.aws.deadline.model.DeleteStorageProfileRequest.wrap(buildAwsValue())
}
object DeleteStorageProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.DeleteStorageProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.DeleteStorageProfileRequest =
      zio.aws.deadline.model
        .DeleteStorageProfileRequest(farmId, storageProfileId)
    def farmId: FarmId
    def storageProfileId: StorageProfileId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getStorageProfileId: ZIO[Any, Nothing, StorageProfileId] =
      ZIO.succeed(storageProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.DeleteStorageProfileRequest
  ) extends zio.aws.deadline.model.DeleteStorageProfileRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val storageProfileId: StorageProfileId =
      zio.aws.deadline.model.primitives
        .StorageProfileId(impl.storageProfileId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.DeleteStorageProfileRequest
  ): zio.aws.deadline.model.DeleteStorageProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
