package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait DependencyConsumerResolutionStatus {
  def unwrap: software.amazon.awssdk.services.deadline.model.DependencyConsumerResolutionStatus
}
object DependencyConsumerResolutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.DependencyConsumerResolutionStatus
  ): zio.aws.deadline.model.DependencyConsumerResolutionStatus = value match {
    case software.amazon.awssdk.services.deadline.model.DependencyConsumerResolutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.DependencyConsumerResolutionStatus.RESOLVED =>
      val r = RESOLVED
      r
    case software.amazon.awssdk.services.deadline.model.DependencyConsumerResolutionStatus.UNRESOLVED =>
      val r = UNRESOLVED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.DependencyConsumerResolutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.DependencyConsumerResolutionStatus =
      software.amazon.awssdk.services.deadline.model.DependencyConsumerResolutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object RESOLVED
      extends zio.aws.deadline.model.DependencyConsumerResolutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.DependencyConsumerResolutionStatus =
      software.amazon.awssdk.services.deadline.model.DependencyConsumerResolutionStatus.RESOLVED
  }
  case object UNRESOLVED
      extends zio.aws.deadline.model.DependencyConsumerResolutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.DependencyConsumerResolutionStatus =
      software.amazon.awssdk.services.deadline.model.DependencyConsumerResolutionStatus.UNRESOLVED
  }
}
