package zio.aws.deadline.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DependencyCounts(
    dependenciesResolved: zio.aws.deadline.model.primitives.Integer,
    dependenciesUnresolved: zio.aws.deadline.model.primitives.Integer,
    consumersResolved: zio.aws.deadline.model.primitives.Integer,
    consumersUnresolved: zio.aws.deadline.model.primitives.Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.DependencyCounts = {
    import DependencyCounts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.DependencyCounts
      .builder()
      .dependenciesResolved(dependenciesResolved: Integer)
      .dependenciesUnresolved(dependenciesUnresolved: Integer)
      .consumersResolved(consumersResolved: Integer)
      .consumersUnresolved(consumersUnresolved: Integer)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.DependencyCounts.ReadOnly =
    zio.aws.deadline.model.DependencyCounts.wrap(buildAwsValue())
}
object DependencyCounts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.DependencyCounts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.DependencyCounts =
      zio.aws.deadline.model.DependencyCounts(
        dependenciesResolved,
        dependenciesUnresolved,
        consumersResolved,
        consumersUnresolved
      )
    def dependenciesResolved: zio.aws.deadline.model.primitives.Integer
    def dependenciesUnresolved: zio.aws.deadline.model.primitives.Integer
    def consumersResolved: zio.aws.deadline.model.primitives.Integer
    def consumersUnresolved: zio.aws.deadline.model.primitives.Integer
    def getDependenciesResolved
        : ZIO[Any, Nothing, zio.aws.deadline.model.primitives.Integer] =
      ZIO.succeed(dependenciesResolved)
    def getDependenciesUnresolved
        : ZIO[Any, Nothing, zio.aws.deadline.model.primitives.Integer] =
      ZIO.succeed(dependenciesUnresolved)
    def getConsumersResolved
        : ZIO[Any, Nothing, zio.aws.deadline.model.primitives.Integer] =
      ZIO.succeed(consumersResolved)
    def getConsumersUnresolved
        : ZIO[Any, Nothing, zio.aws.deadline.model.primitives.Integer] =
      ZIO.succeed(consumersUnresolved)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.DependencyCounts
  ) extends zio.aws.deadline.model.DependencyCounts.ReadOnly {
    override val dependenciesResolved
        : zio.aws.deadline.model.primitives.Integer =
      impl.dependenciesResolved(): zio.aws.deadline.model.primitives.Integer
    override val dependenciesUnresolved
        : zio.aws.deadline.model.primitives.Integer =
      impl.dependenciesUnresolved(): zio.aws.deadline.model.primitives.Integer
    override val consumersResolved: zio.aws.deadline.model.primitives.Integer =
      impl.consumersResolved(): zio.aws.deadline.model.primitives.Integer
    override val consumersUnresolved
        : zio.aws.deadline.model.primitives.Integer =
      impl.consumersUnresolved(): zio.aws.deadline.model.primitives.Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.DependencyCounts
  ): zio.aws.deadline.model.DependencyCounts.ReadOnly = new Wrapper(impl)
}
