package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{IdentityCenterPrincipalId, FarmId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateMemberFromFarmRequest(
    farmId: FarmId,
    principalId: IdentityCenterPrincipalId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFarmRequest = {
    import DisassociateMemberFromFarmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFarmRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .principalId(
        IdentityCenterPrincipalId.unwrap(principalId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.DisassociateMemberFromFarmRequest.ReadOnly =
    zio.aws.deadline.model.DisassociateMemberFromFarmRequest
      .wrap(buildAwsValue())
}
object DisassociateMemberFromFarmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFarmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.DisassociateMemberFromFarmRequest =
      zio.aws.deadline.model
        .DisassociateMemberFromFarmRequest(farmId, principalId)
    def farmId: FarmId
    def principalId: IdentityCenterPrincipalId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getPrincipalId: ZIO[Any, Nothing, IdentityCenterPrincipalId] =
      ZIO.succeed(principalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFarmRequest
  ) extends zio.aws.deadline.model.DisassociateMemberFromFarmRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val principalId: IdentityCenterPrincipalId =
      zio.aws.deadline.model.primitives
        .IdentityCenterPrincipalId(impl.principalId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFarmRequest
  ): zio.aws.deadline.model.DisassociateMemberFromFarmRequest.ReadOnly =
    new Wrapper(impl)
}
