package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  IdentityCenterPrincipalId,
  FleetId,
  FarmId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateMemberFromFleetRequest(
    farmId: FarmId,
    fleetId: FleetId,
    principalId: IdentityCenterPrincipalId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFleetRequest = {
    import DisassociateMemberFromFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFleetRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .principalId(
        IdentityCenterPrincipalId.unwrap(principalId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.DisassociateMemberFromFleetRequest.ReadOnly =
    zio.aws.deadline.model.DisassociateMemberFromFleetRequest
      .wrap(buildAwsValue())
}
object DisassociateMemberFromFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.DisassociateMemberFromFleetRequest =
      zio.aws.deadline.model
        .DisassociateMemberFromFleetRequest(farmId, fleetId, principalId)
    def farmId: FarmId
    def fleetId: FleetId
    def principalId: IdentityCenterPrincipalId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getPrincipalId: ZIO[Any, Nothing, IdentityCenterPrincipalId] =
      ZIO.succeed(principalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFleetRequest
  ) extends zio.aws.deadline.model.DisassociateMemberFromFleetRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val fleetId: FleetId =
      zio.aws.deadline.model.primitives.FleetId(impl.fleetId())
    override val principalId: IdentityCenterPrincipalId =
      zio.aws.deadline.model.primitives
        .IdentityCenterPrincipalId(impl.principalId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFleetRequest
  ): zio.aws.deadline.model.DisassociateMemberFromFleetRequest.ReadOnly =
    new Wrapper(impl)
}
