package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  IdentityCenterPrincipalId,
  JobId,
  QueueId,
  FarmId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateMemberFromJobRequest(
    farmId: FarmId,
    queueId: QueueId,
    jobId: JobId,
    principalId: IdentityCenterPrincipalId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.DisassociateMemberFromJobRequest = {
    import DisassociateMemberFromJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.DisassociateMemberFromJobRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .principalId(
        IdentityCenterPrincipalId.unwrap(principalId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.DisassociateMemberFromJobRequest.ReadOnly =
    zio.aws.deadline.model.DisassociateMemberFromJobRequest
      .wrap(buildAwsValue())
}
object DisassociateMemberFromJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.DisassociateMemberFromJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.DisassociateMemberFromJobRequest =
      zio.aws.deadline.model.DisassociateMemberFromJobRequest(
        farmId,
        queueId,
        jobId,
        principalId
      )
    def farmId: FarmId
    def queueId: QueueId
    def jobId: JobId
    def principalId: IdentityCenterPrincipalId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getPrincipalId: ZIO[Any, Nothing, IdentityCenterPrincipalId] =
      ZIO.succeed(principalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.DisassociateMemberFromJobRequest
  ) extends zio.aws.deadline.model.DisassociateMemberFromJobRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val principalId: IdentityCenterPrincipalId =
      zio.aws.deadline.model.primitives
        .IdentityCenterPrincipalId(impl.principalId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.DisassociateMemberFromJobRequest
  ): zio.aws.deadline.model.DisassociateMemberFromJobRequest.ReadOnly =
    new Wrapper(impl)
}
