package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  IdentityCenterPrincipalId,
  QueueId,
  FarmId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateMemberFromQueueRequest(
    farmId: FarmId,
    queueId: QueueId,
    principalId: IdentityCenterPrincipalId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.DisassociateMemberFromQueueRequest = {
    import DisassociateMemberFromQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.DisassociateMemberFromQueueRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .principalId(
        IdentityCenterPrincipalId.unwrap(principalId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.DisassociateMemberFromQueueRequest.ReadOnly =
    zio.aws.deadline.model.DisassociateMemberFromQueueRequest
      .wrap(buildAwsValue())
}
object DisassociateMemberFromQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.DisassociateMemberFromQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.DisassociateMemberFromQueueRequest =
      zio.aws.deadline.model
        .DisassociateMemberFromQueueRequest(farmId, queueId, principalId)
    def farmId: FarmId
    def queueId: QueueId
    def principalId: IdentityCenterPrincipalId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getPrincipalId: ZIO[Any, Nothing, IdentityCenterPrincipalId] =
      ZIO.succeed(principalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.DisassociateMemberFromQueueRequest
  ) extends zio.aws.deadline.model.DisassociateMemberFromQueueRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val principalId: IdentityCenterPrincipalId =
      zio.aws.deadline.model.primitives
        .IdentityCenterPrincipalId(impl.principalId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.DisassociateMemberFromQueueRequest
  ): zio.aws.deadline.model.DisassociateMemberFromQueueRequest.ReadOnly =
    new Wrapper(impl)
}
