package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{EbsThroughputMiB, EbsIops}
import scala.jdk.CollectionConverters._
final case class Ec2EbsVolume(
    sizeGiB: Optional[zio.aws.deadline.model.primitives.Integer] =
      Optional.Absent,
    iops: Optional[EbsIops] = Optional.Absent,
    throughputMiB: Optional[EbsThroughputMiB] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.Ec2EbsVolume = {
    import Ec2EbsVolume.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.Ec2EbsVolume
      .builder()
      .optionallyWith(sizeGiB.map(value => value: Integer))(_.sizeGiB)
      .optionallyWith(iops.map(value => EbsIops.unwrap(value): Integer))(_.iops)
      .optionallyWith(
        throughputMiB.map(value => EbsThroughputMiB.unwrap(value): Integer)
      )(_.throughputMiB)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.Ec2EbsVolume.ReadOnly =
    zio.aws.deadline.model.Ec2EbsVolume.wrap(buildAwsValue())
}
object Ec2EbsVolume {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.Ec2EbsVolume
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.Ec2EbsVolume =
      zio.aws.deadline.model.Ec2EbsVolume(
        sizeGiB.map(value => value),
        iops.map(value => value),
        throughputMiB.map(value => value)
      )
    def sizeGiB: Optional[zio.aws.deadline.model.primitives.Integer]
    def iops: Optional[EbsIops]
    def throughputMiB: Optional[EbsThroughputMiB]
    def getSizeGiB
        : ZIO[Any, AwsError, zio.aws.deadline.model.primitives.Integer] =
      AwsError.unwrapOptionField("sizeGiB", sizeGiB)
    def getIops: ZIO[Any, AwsError, EbsIops] =
      AwsError.unwrapOptionField("iops", iops)
    def getThroughputMiB: ZIO[Any, AwsError, EbsThroughputMiB] =
      AwsError.unwrapOptionField("throughputMiB", throughputMiB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.Ec2EbsVolume
  ) extends zio.aws.deadline.model.Ec2EbsVolume.ReadOnly {
    override val sizeGiB: Optional[zio.aws.deadline.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sizeGiB())
        .map(value => value: zio.aws.deadline.model.primitives.Integer)
    override val iops: Optional[EbsIops] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => zio.aws.deadline.model.primitives.EbsIops(value))
    override val throughputMiB: Optional[EbsThroughputMiB] =
      zio.aws.core.internal
        .optionalFromNullable(impl.throughputMiB())
        .map(value => zio.aws.deadline.model.primitives.EbsThroughputMiB(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.Ec2EbsVolume
  ): zio.aws.deadline.model.Ec2EbsVolume.ReadOnly = new Wrapper(impl)
}
