package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait Ec2MarketType {
  def unwrap: software.amazon.awssdk.services.deadline.model.Ec2MarketType
}
object Ec2MarketType {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.Ec2MarketType
  ): zio.aws.deadline.model.Ec2MarketType = value match {
    case software.amazon.awssdk.services.deadline.model.Ec2MarketType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.Ec2MarketType.ON_DEMAND =>
      val r = `on-demand`
      r
    case software.amazon.awssdk.services.deadline.model.Ec2MarketType.SPOT =>
      val r = spot
      r
  }
  case object unknownToSdkVersion extends zio.aws.deadline.model.Ec2MarketType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.Ec2MarketType =
      software.amazon.awssdk.services.deadline.model.Ec2MarketType.UNKNOWN_TO_SDK_VERSION
  }
  case object `on-demand` extends zio.aws.deadline.model.Ec2MarketType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.Ec2MarketType =
      software.amazon.awssdk.services.deadline.model.Ec2MarketType.ON_DEMAND
  }
  case object spot extends zio.aws.deadline.model.Ec2MarketType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.Ec2MarketType =
      software.amazon.awssdk.services.deadline.model.Ec2MarketType.SPOT
  }
}
